/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.mpeg;

/**
 * Exception thrown on an attempt to parse a corrupt MPEG frame header
 *
 * @author Nigel Atkinson (<a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>)
 */
public class CorruptMPEGHeaderException extends Exception
{
	private int header = 0;

	/**
	 * Public constructor
	 *
	 * @param headerstring The corrupt header data
	 */
	public CorruptMPEGHeaderException(int headerstring)
	{
		header = headerstring;
	}
}
