/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.mpeg;

import java.io.*;

/**
 * This class is a simple checker to make sure we're not trying to access anything
 * but MP3 files (eg ones that end in ".mp3").
 *
 * @author Nick Vincent <a href="mailto:nick@neoworks.com">nick@neoworks.com</a>
 */
public class MP3FileFilter implements FilenameFilter
{
	/** Creates a new instance of MP3FileFilter */
	public MP3FileFilter()
	{
	}

	/**
	 * Check the filename for the correct extension.
	 *
	 * @param file The file object to check
	 * @param str The filename to check
	 * @return Success
	 */
	public boolean accept(java.io.File file, String str)
	{
		return str.toLowerCase().endsWith(".mp3");
	}
}
