/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.rdc;

import java.util.*;

/**
 * A class to represent a symbol table. The table uses tokens to represent
 * the identifiers held in it.<p>This is realy a TokenList but its nicer to
 * call it a SymbolTable when it is a symbol table ok!
 *
 * @see Token
 */
public class SymbolTable extends TokenList
{
  /**
   * Create a new symbol table using the tokens passed. The tokens are in a vector
   * and represent the contence of the symbol table.
   */
  public SymbolTable(Vector newTokenList)
  {
    super(newTokenList);
  }

  /**
   * Checks if a token is in the SymbolTable. Looks for a token in the table with
   * the same lexeme as in the findToken passed. Note that it does the search on the
   * lexeme only not the type or the value. Returns the index of the token in the
   * table or -1 if it is not found in the table.
   *
   * @param findToken  The token to look for in the table
   * @return The index of the token in the table (or -1 if not found)
   */
  public int isInTable(Token findToken)
  {
    return this.tokenIsIn(findToken);
  }

}
