/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.rdc;

/**
 * A class to represent tokens passed by the lexer.
 */
public class Token
{
  private int tokenType;                // The type of the token
  private int tokenValue;               // The value of the token
  private String lexeme;                // The text of the token

  private int tokenStart;               // The index into the input string

  /**
   * Construct the class by setting the values to the arguments passed.
   *
   * @param tokenType   The type of the token
   * @param tokenValue  The value of the token
   * @param lexeme      The text of the token
   */
  public Token(int tokenType, int tokenValue, String lexeme)
  {
    this.tokenType = tokenType;
    this.tokenValue = tokenValue;
    this.lexeme = lexeme;
    this.tokenStart = -1;
  }

  /**
   * Construct the class by setting the values to the arguments passed.
   *
   * @param tokenType   The type of the token
   * @param tokenValue  The value of the token
   * @param lexeme      The text of the token
   * @param tokenStart  The offset into the input string
   */
  public Token(int tokenType, int tokenValue, String lexeme, int tokenStart)
  {
    this.tokenType = tokenType;
    this.tokenValue = tokenValue;
    this.lexeme = lexeme;
    this.tokenStart = tokenStart;
  }

  /**
   * Copy constructor to create a token from another token.
   *
   * @param copyToken  The token to copy into this one
   */
  public Token (Token copyToken)
  {
    this.tokenType  = copyToken.tokenType;
    this.tokenValue = copyToken.tokenValue;
    this.lexeme = new String(copyToken.lexeme);
    this.tokenStart = copyToken.tokenStart;
  }

  /**
   * Copy constructor to create a token from another token.
   *
   * @param copyToken  The token to copy into this one
   * @param tokenStart The new token start value
   */
  public Token (Token copyToken, int tokenStart)
  {
    this.tokenType  = copyToken.tokenType;
    this.tokenValue = copyToken.tokenValue;
    this.lexeme = new String(copyToken.lexeme);
    this.tokenStart = tokenStart;
  }


  /**
   * Return the type of the token
   */
  public int getTokenType()
  {
    return tokenType;
  }

  /**
   * Return the value of the token
   */
  public int getTokenValue()
  {
    return tokenValue;
  }

  /**
   * Return the lexeme of the token
   */
  public String getLexeme()
  {
    return lexeme;
  }

  /**
   * Return the start index of the token
   */
  public int getStart()
  {
    return tokenStart;
  }
  
  public String toString()
  {
	  return (new String("com.neoworks.rdc.Token [Type: " + tokenType + ", Value: " + tokenValue + ", Lexeme: " + lexeme + "]"));
  }

}
