/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.rdc;

import java.util.Vector;


/**
 * Class which holds a vector of Tokens, and the last position
 * accessed in the array.
 */
public class TokenList
{
  protected Vector tokenData;           // the actual tokens held

  /**
   * Copy constructor. Creat a new TokenList from an existing TokenList.
   * This does a shalow copy of the tokens in the list.
   * To do a deep copy of the vetor use the clone method.
   * Note that this does not do a deep copy of the elements
   * in the vector so they should also be cloned seperatly.
   *
   * @param copyList    The token list to copy into this one
   */
  public TokenList(TokenList copyList)
  {
    tokenData = copyList.tokenData;
  }

  /**
   * Create a new token list from a vector of tokens. The tokens in the
   * vector are added in the same order to the list. The next pointer is then
   * set to the end of the list.
   *
   * @param newTokenList    A vector of tokens to start the new tokenList
   */
  public TokenList(Vector newTokenList)
  {
    tokenData = new Vector();

    // N.B. if the assignment inside this for loop creates a reference to
    // a Token, then we may have to change it to explicitly call the
    // giveTokenValue function etc.

    for (int indexCounter=0; indexCounter<newTokenList.size(); indexCounter++)
    {
      tokenData.addElement(newTokenList.elementAt(indexCounter));
    }
  }

  /**
   * Create a new empty list of tokens
   */
  public TokenList()
  {
    tokenData = new Vector();
  }

  /**
   * This function appends a token to the end of the TokenList, and increments
   * nextPosition.
   *
   * @param newToken     The new token to be added to the array.
   */
  public void addToken (Token newToken)
  {
    tokenData.addElement(/*new Token (*/newToken/*)*/);
  }

  /**
   * Returns the token at a position in the list. Will throw an out of
   * bounds exception if the index is out of bounds.
   *
   * @param tokenIndex  The index of the token in the list to return
   * @return The token at the index passed
   */
  public Token getTokenAt(int tokenIndex)
  {
    return (Token) tokenData.elementAt(tokenIndex);
  }

  /**
   * Removes a token from the list at the specified position
   *
   * @param tokenIndex  The index of the token in the list to remove
   */
  public void removeTokenAt(int tokenIndex)
  {
    tokenData.removeElementAt(tokenIndex);
  }

  /**
   * Returns the index of the next position in the list
   *
   * @return The index of the next position in the list
   */
  public int getSize()
  {
    return tokenData.size();
  }

  /**
   * Find the index of a token in the list. Finds a token in the list with
   * the same lexeme as in the findThisToken token passed. Note that this
   * only compares the lexems and not the types or values!! Returns the index
   * of the found token or -1 if no token found.
   *
   * @param findThisToken  The token to look for
   * @return The index of the found token (or -1 if not found)
   */
  public int tokenIsIn(Token findThisToken)
  {
    String testVal = new String (findThisToken.getLexeme());
    String checkVal;

    for (int i=0; i<tokenData.size(); i++)
    {
      checkVal = ((Token) tokenData.elementAt(i)).getLexeme();

      if (checkVal.equals(testVal))
      {
        return i;
      }
    }
    return -1;
  }

}

