/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.util;

/**
 * A one argument function block.
 *
 * The value(Object) function should be overrided to provided the implementation
 * of the function block. This will typicaly be done inline. e.g.
 *
 * <code>
 *    new OneBlock() { public Object value(Object arg1) { return (((Boolean)arg1) == Boolean.TRUE) ? Boolean.FALSE : Boolean.TRUE } }
 * </code>
 *
 * The above trivial example is a OneBlock that takes an argument, casts it to a
 * Boolean and returns the inverse of the argument. This function could be mapped
 * over a collection of Booleans to produce the NOT of the collection.
 *
 * @author  Nicko Cadell <a href="mailto:nicko@neoworks.com">nicko@neoworks.com</a>
 * @version $Revision: 1.4 $
 */
public class OneBlock
{
	/**
	 * Optional parametarised value
	 */
	protected Object data = null;
	
	/**
	 * Default constructor
	 */
	public OneBlock()
	{
	}
	
	/**
	 * Parametarised constructor.
	 *
	 * @param value Value to paramatarise the OneBlock
	 */
	public OneBlock(Object value)
	{
		data = null;
	}
	
	/**
	 * This function should be overriden by the implementation
	 *
	 * @param arg1 The argument to the OneBlock
	 * @return the value to return
	 */
	public Object value(Object arg1)
	{
		return null;
	}
}

