/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.util;

/**
 * Holds a pair of Objects.  Useful for passing pairs of values, surprisingly.
 *
 * @author Nick Vincent (<a href="mailto:nick@neoworks.com">nick@neoworks.com</a>)
 * @version $Revision: 1.4 $
 */
public class Pair
{
	/**
	 * First field in the Pair
	 */
	public Object first = null;
	/**
	 * Second field in the Pair
	 */
	public Object second = null;
	
	/** 
	 * Creates new Pair object.
	 * Initialises the members to null
	 */
	public Pair() 
	{
		this(null, null);
	}
	
	/**
	 * Creates a new Pair object.
	 * Initialises the members as specified.
	 *
	 * @param firstval The value of the first member of the Pair
	 * @param secondval The value of the second member of the Pair
	 */
	public Pair(Object firstval, Object secondval)
	{
		first  = firstval;
		second = secondval;
	}

	/**
	 * Get a String representation of this Pair
	 *
	 * @return A String
	 */
	public String toString()
	{
		return ( "(" + first + "," + second + ")" );
	}
}
