/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.util;

import java.util.LinkedHashMap;
import java.util.Map;

/**
 * Size limited HashMap, where elements are held in a LinkedList, ordered as inserted.
 *
 * @author Nigel Atkinson (<a href="mailto:nigel@neoworks.com">nigel@neoworks.com</a>)
 */
public class SizeLimitedLinkedHashMap extends LinkedHashMap
{
	private int maxSize = 0;

	/**
	 * Public constructor
	 *
	 * @param maxSize The maximum number of elements to hold
	 */
	public SizeLimitedLinkedHashMap(int maxSize)
	{
		super(maxSize, 0.75f, false);
		this.maxSize = maxSize;
	}

	/**
	 * Get the maximum number of elements
	 *
	 * @return The maximum number of elements
	 */
	public int getMaxSize()
	{
		return maxSize;
	}

	/**
	 * Set the maximum number of elements
	 *
	 * @param maxSize The maximum number of elements
	 */
	public void setMaxSize(int maxSize)
	{
		this.maxSize = maxSize;
	}

	/**
	 * Oldest element removal policy
	 */
	protected boolean removeEldestEntry(Map.Entry eldest)
	{
	        return size() > maxSize;
	}
}
