/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.util;

import java.lang.StringBuffer;
import java.util.Map;
import java.util.TreeMap;
import java.lang.Object;
import java.lang.String;
import java.lang.Character;
import java.util.AbstractMap;
import java.util.SortedMap;

/**
 * Static methods for escaping strings
 *
 * @author Nick Vincent <a href="mailto:nick@neoworks.com">nick@neoworks.com</a>
 * @version $Revision: 1.2 $
 */
public class StringEscaper
{
	/**
	 * Declare a map of special chars
	 */
	private static Map _specialChars = null;
	
	/**
	 * Private constructor to prevent construction
	 */
	private StringEscaper()
	{
	}
	
	/**
	 * Escape a string using predefined characters.
	 *
	 * This will escape the following Characters
	 *
	 * Line Feed		\n	->	\\n\n
	 * Tab				\t	->	\\t\t
	 * Double Quote		\"	->	\\\"
	 * Carriage Return	\r	->	\\r\r
	 *
	 * @param str The string to escape
	 * @return The escaped string
	 */
	public static String escape(String str)
	{
		return escape(str, _specialChars);
	}
	
	/**
	 * Escape a string using a supplied remapping
	 *
	 * @param str the string to escapse
	 * @param remapChars A Map of Character to String object. These chars are remmaped.
	 * @return The escapsed string
	 */
	public static String escape(String str, Map remapChars)
	{
		char[] strChars = str.toCharArray();	//Get a charArray.  Much quicker.  Vroom.
		int strCharsLength = strChars.length;
		StringBuffer retval = new StringBuffer(strCharsLength*2);		//Add 10% for growage
		
		for (int count=0; count<strCharsLength; count++)
		{
			Character currChar = new Character(strChars[count]);
			String currCharRep = (String) remapChars.get(currChar);	// See if we have a special char
			if ( currCharRep == null )
			{
				retval.append(currChar);
			}
			else
			{
				retval.append(currCharRep);
			}
		}
		
		return retval.toString();
	}
	
	/*
	 * Define here the predefined mapping
	 */
	static
	{
		_specialChars = new TreeMap();
		
		_specialChars.put(new Character('\n'),"\\n\n");		// Line Feed
		_specialChars.put(new Character('\t'),"\\t\t");		// Tab
		_specialChars.put(new Character('"'),"\\\"");		// Double quote
		_specialChars.put(new Character('\r'),"\\r\r");		// Carriage Return
	}

}
