/***************************************************************************
    Copyright          : (C) 2002 by Neoworks Limited. All rights reserved
    URL                : http://www.neoworks.com
 ***************************************************************************/
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

package com.neoworks.util;

/**
 * Like the OneBlock this is a function block that takes two arguments.
 * A comparison function could be written as:
 *
 * <code>
 * new TwoBlock() {
 *     public Object value(Object fst, Object snd)
 *     {return new Integer(((String)fst).compareTo((String)snd));}
 * }
 * </code>
 *
 * @author  Nicko Cadell <a href="mailto:nicko@neoworks.com">nicko@neoworks.com</a>
 * @version $Revision: 1.4 $
 */
public class TwoBlock
{
	/**
	 * parametarised data
	 */	
	protected Object data = null;		// The parametarised value
	
	/**
	 * Default constructor
	 */
	public TwoBlock()
	{
	}
	
	/**
	 * Parametrarised constructor
	 *
	 * @param value The parameter to the object
	 */
	public TwoBlock(Object value)
	{
		data = null;
	}
	
	/**
	 * This function should be overriden by the implementation
	 *
	 * @param arg1 The first argument to the TwoBlock
	 * @param arg2 The second argument to the TwoBlock
	 * @return Return the result
	 */
	public Object value(Object arg1, Object arg2)
	{
		return null;
	}
}

